<?php declare(strict_types=1);

namespace Newland\NeosRoutingBehaviourHooks\Utility;

class UrlUtility
{
    public static function stripOutDuplicateHostsInUrl(string $url): string
    {
        if (\Safe\preg_match('/^https?:\/\/.*(https?:\/\/.*)$/', $url, $matches)) {
            return $matches[1];
        }
        return $url;
    }
}
