<?php
namespace Newland\NeosRoutingBehaviourHooks\Foundation;

/*
 * This file is part of the "neos-routing-behaviour" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Aop\JoinPointInterface;
use Neos\Flow\Mvc\ActionRequest;
use Neos\Flow\Mvc\Routing\UriBuilder;
use Neos\Neos\Domain\Service\ContentContext;

/**
 * @Flow\Aspect()
 */
class IgnoreFrontendUrisinBackendAspect
{
    /**
     * @Flow\Around("method(Neos\Flow\Mvc\Routing\UriBuilder->uriFor())")
     */
    public function uriFor(JoinPointInterface $joinPoint)
    {
        /** @var UriBuilder $proxy */
        $proxy = $joinPoint->getProxy();
        /** @var ActionRequest $request */
        $request = $proxy->getRequest();
        /** @var NodeInterface $node |null */
        $node = $request->getInternalArgument('__node');

        if ($node instanceof NodeInterface) {
            /** @var ContentContext $context */
            $context = $node->getContext();
            if ($context->isInBackend()) {
                return '#';
            }
        }

        return $joinPoint->getAdviceChain()->proceed($joinPoint);
    }
}
