<?php
namespace Newland\NeosRoutingBehaviourHooks\Tests\Unit\Behaviour;


use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Http\Uri;
use Neos\Flow\Mvc\Routing\Dto\RouteContext;
use Neos\Flow\Mvc\Routing\Dto\RouteParameters;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosRoutingBehaviourHooks\Behaviour\HostnameDimensionMatcher;
use Newland\NeosRoutingBehaviourHooks\Foundation\CustomDimensionResolution\DimensionResolutionContext;
use Newland\NeosRoutingBehaviourHooks\Foundation\RouteWrappingHelper;
use Newland\NeosRoutingBehaviourHooks\Utility\NamedDimensionCollection;
use Neos\Flow\Http\Request as HttpRequest;

class HostnameDimensionMatcherTest extends FunctionalTestCase
{

    /** @var HostnameDimensionMatcher */
    private $subject;

    /** @var RouteWrappingHelper */
    private $helper;

    public function setUp()
    {
        parent::setUp();

        $this->subject = new HostnameDimensionMatcher();
        $this->inject($this->subject, 'hostMapping', new NamedDimensionCollection([
            'de.test.com' => [ 'language' => ['de'] ],
            'en.test.com' => [ 'language' => ['en'] ],
            'fr.test.com' => [ 'language' => ['fr'] ],
        ]));

        $this->helper = new RouteWrappingHelper();
        $this->helper->setUri(new Uri('http://test.com/foo/bar'));
        $this->inject($this->subject, 'helper', $this->helper);
    }

    public function testAlwaysResolvesDimensionsToEmptyString()
    {
        $context = new DimensionResolutionContext();
        $this->assertEquals('', $this->subject->resolveDimensions($context, []));
        $this->assertEquals('', $this->subject->resolveDimensions($context, [ 'language' => ['de'] ]));
        $this->assertEquals('', $this->subject->resolveDimensions($context, [ 'language' => ['en'] ]));
        $this->assertEquals('', $this->subject->resolveDimensions($context, [ 'foo' => 'bar' ]));
    }

    public function testDoesNotResolveDimensionsWhenInBackend()
    {
        $this->helper->setUri(new Uri('https://de.test.com/neos/content'));
        $context = new DimensionResolutionContext();
        $this->assertEquals(null, $this->subject->resolveDimensions($context, []));
        $this->assertEquals(null, $this->subject->resolveDimensions($context, [ 'language' => ['de'] ]));
        $this->assertEquals(null, $this->subject->resolveDimensions($context, [ 'language' => ['en'] ]));
        $this->assertEquals(null, $this->subject->resolveDimensions($context, [ 'foo' => 'bar' ]));
    }

    public function testMatchesDimensionsFromHostname()
    {
        $uri = new Uri('https://de.test.com/foo/bar');
        $this->helper->setUri($uri);
        $this->assertEquals(
            [ 'language' => ['de'] ],
            $this->subject->parseDimensions(new DimensionResolutionContext(), $uri)
        );
    }

    public function testDoesNotMatchDimensionsWhenInBackend()
    {
        $uri = new Uri('https://de.test.com/neos/content');
        $this->helper->setUri($uri);
        $this->assertEquals(
            null,
            $this->subject->parseDimensions(new DimensionResolutionContext(), $uri)
        );
    }
}
