<?php
namespace Newland\NeosRoutingBehaviourHooks\Tests\Unit\Foundation;


use Neos\Flow\Http\Uri;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosRoutingBehaviourHooks\Foundation\RouteWrappingHelper;
use Newland\NeosRoutingBehaviourHooks\Tests\Unit\Foundation\Mock\MockBehaviourImplementation;

class RouteWrappingHelperTest extends FunctionalTestCase
{

    /** @var RouteWrappingHelper */
    private $subject;

    public function setUp()
    {
        parent::setUp();
        $this->subject = new RouteWrappingHelper();
        $this->inject($this->subject, 'configuration', [
            [ 'implementation' => MockBehaviourImplementation::class, 'parameters' => [ 'foo' => 'bar' ] ],
            [ 'implementation' => MockBehaviourImplementation::class ],
        ]);
    }

    public function testInitializesConfiguredBehaviours()
    {
        $behaviours = $this->subject->behaviours();
        $this->assertInstanceOf(MockBehaviourImplementation::class, $behaviours[0]);
    }

    public function testPassesParameters()
    {
        $behaviours = $this->subject->behaviours();
        $this->assertEquals([ 'foo' => 'bar' ], $behaviours[0]->getParameters());
    }

    public function testPassesEmptyParameterArrayIfNoneConfigured()
    {
        $behaviours = $this->subject->behaviours();
        $this->assertEquals([], $behaviours[1]->getParameters());
    }

    public function testShouldFigureOutIfRequestIsToBackendRoute()
    {
        $this->subject->setUri(new Uri('http://test.com/neos/foobar'));
        $this->assertTrue($this->subject->isBackendRoute(), $this->subject->getUri() . ' should be backend uri');

        $this->subject->setUri(new Uri('http://test.com/some/frontend/route'));
        $this->assertFalse($this->subject->isBackendRoute(), $this->subject->getUri() . ' should not be backend uri');

        $this->subject->setUri(new Uri('http://test.com/some/frontend/route/conatining/string/neos/in/it'));
        $this->assertFalse($this->subject->isBackendRoute(), $this->subject->getUri() . ' should not be backend uri');
    }

}
