<?php
namespace Newland\NeosRoutingBehaviourHooks\Tests;


use J6s\PhpArch\Component\Architecture;
use J6s\PhpArch\PhpArch;
use J6s\PhpArch\Validation\MustBeSelfContained;
use PHPUnit\Framework\TestCase;

class ArchitectureTest extends TestCase
{

    public function testArchitecture()
    {
        $architecture = new Architecture();
        $architecture
            ->component('Foundation')
            ->identifiedByNamespace($this->ns('Foundation'))
            ->mustNotDependOn('Behaviour')
            ->identifiedByNamespace($this->ns('Behaviour'));

        $architecture
            ->component('CustomDimensionResolution')
            ->identifiedByNamespace($this->ns('Behaviour\\CustomDimensionResolution'))
            ->mustOnlyDependOn('Foundation');
        $architecture
            ->component('IgnoreMatchedRoutes')
            ->identifiedByNamespace($this->ns('Behaviour\\IgnoreMatchedRoutes'))
            ->mustOnlyDependOn('Foundation');
        $architecture
            ->component('ModifyResolveContext')
            ->identifiedByNamespace($this->ns('Behaviour\\ModifyResolveContext'))
            ->mustOnlyDependOn('Foundation');

        (new PhpArch())
            ->fromDirectory(__DIR__ . '/../Classes')
            ->validate($architecture)
            ->assertHasNoErrors();
    }

    private function ns(string $subNameSpace): string
    {
        return 'Newland\\NeosRoutingBehaviourHooks\\' . $subNameSpace;
    }

}
