# Neos Routing Behaviour Hooks

Package that allows hooking into neos routing in order to supply
custom behaviours.

## Table of Contents

- [Installation](#markdown-header-installation)
- [For Integrators](#markdown-header-for-integrators)
    - [HostnameDimensionMatcher](#markdown-header-hostnamedimensionmatcher)
    - [Implementing your own behaviour](#markdown-header-implementing-your-own-behaviour)
- [For developers](#markdown-header-for-developers)
    - [Architectural setup](#markdown-header-architectural-setup)

## Installation

To install this package you have to add the git repository to the `repositories` section of your `composer.json` and the require the package:

- `composer.json`:
```
{
  "repositories": [
    {
      "type": "vcs",
      "url": "git@bitbucket.org:landinsicht/neos-routing-behaviour-hooks.git"
    }
  ],
}
```
- `$ composer require newland/neos-routing-behaviour-hooks`

## For Integrators

Behaviours can be configured in `Newland.NeosRoutingBehaviourBooks.behaviours` - which must be an array of arrays - each inner array must contain a class name as `implementation` and further configuration for that behaviour as `parameters`.

```yaml
Newland:
  NeosRoutingBehaviourHooks:
    behaviours:
      - implementation: 'Newland\NeosRoutingBehaviourHooks\Behaviour\HostnameDimensionMatcher'
        parameters:
          hosts:
              'toubiz-frontend.en.ddev.local':
                language: en
              'toubiz-frontend.de.ddev.local':
                language: de
              'toubiz-frontend.fr.ddev.local':
                language: fr
```

Routes are heavily cached, be sure to clear all caches after changing the configuration.

### HostnameDimensionMatcher
This behaviour allows matching dimensions (such as language) by the hostname instead of as a part of the URL. This allows you to have multilingual pages on `test.de`, `test.co.uk` and `test.com` instead of `test.de/de`, `test.de/uk` and `test.de/us`.

The `host` parameter must be a mapping from hostname to dimension values.

The optional `disallowOtherHostnames` can be set to `true` if nodes should only be accessible from
their respective hostnames. This is only a safeguarding measure and should be set to `false` most
times. Be careful with this setting: Setting it will require you to configure every hostname the
page runs under explicitly.

Example configuration:

```yaml
Newland:
  NeosRoutingBehaviourHooks:
    behaviours:
      - implementation: 'Newland\NeosRoutingBehaviourHooks\Behaviour\HostnameDimensionMatcher'
        parameters:
          hosts:
              'toubiz-frontend.en.ddev.local':
                language: en
              'toubiz-frontend.de.ddev.local':
                language: de
              'toubiz-frontend.fr.ddev.local':
                language: fr
          disallowOtherHostnames: true
```

### Implementing your own behaviour

You can implement your own behaviour by extending the `Newland\NeosRoutingBehaviourHooks\Foundation\Behaviour` class and implementing any of the supplied interfaces in the `Foundation` namespace.


## For Developers
### Architectural setup

There are a couple of limitations that this package works around.
To understand how this package is structured we first have to have a look at
how Flow & Neos handle routing:

- Flow has the concept of Http components: The component chain (ordered list of components)
  is run for every request
- The Neos router is one such Http component
- Neos routes are built using multiple route parts. The route `{node}/foo/{--plugin.article}`
  for example is made up from 3 parts: One dynamic route part `{node}`, one static `/foo/` and another
  dynamic `{--plugin.article}`.
- Http components can save parameters to the context which later can be used by parameter aware
  route parts.
  
Because by default route parts only operate on the uri path the first vital component of this
package is the `RouteParameterExtractor`: It is a Flow Http component that extracts additional
information about the route (e.g. the current hostname) into `RouteWrappingHelper` for later usage.
To use that information you can inject `RouteWrappingHelper` whereever you want.

During the later routing phase multiple Aspects (one for each type of hook) modify the routing
flow and manipulate the data in the router.
