<?php
namespace Newland\NeosNodeTypes\Video;

use Newland\NeosNodeTypes\Exception\UnknownVideoException;

class YoutubeVideo extends AbstractVideo
{

    /** @var string */
    private $videoId;

    public function __construct(string $url)
    {
        $this->videoId = $this->extractVideoId($url);
    }

    public function getEmbedUrl(): string
    {
        return '//www.youtube-nocookie.com/embed/' . $this->videoId . '?rel=0&autoplay=1';
    }

    public function getPreviewUrl(): string
    {
        return '//i.ytimg.com/vi/' . $this->videoId . '/maxresdefault.jpg';
    }

    private function extractVideoId(string $url): string
    {
        $parsed = parse_url($url);

        if ($parsed === false) {
            throw new UnknownVideoException('The url ' . $url . ' cannot be parsed.');
        }

        // Regular youtube urls: https://youtube.com/watch?v={ID_GOES_HERE}
        if (array_key_exists('query', $parsed)
            && preg_match('/v=(.+)/', $parsed['query'], $queryMatches)
        ) {
            return $queryMatches[1];
        }

        // Embed urls: https://www.youtube.com/embed/{ID_GOES_HERE}
        if (array_key_exists('path', $parsed)
            && preg_match('/\/embed\/(\w+)/', $parsed['path'], $pathMatches)
        ) {
            return $pathMatches[1];
        }

        throw new UnknownVideoException('The url ' . $url . ' cannot be parsed as Youtube URL');
    }
}
