<?php
namespace Newland\NeosNodeTypes\Video;

use Neos\Eel\ProtectedContextAwareInterface;

abstract class AbstractVideo implements ProtectedContextAwareInterface
{

    abstract public function __construct(string $url);

    abstract public function getEmbedUrl(): string;

    abstract public function getPreviewUrl(): string;

    public function allowsCallOfMethod($methodName): bool
    {
        return $methodName === 'getEmbedUrl' || $methodName === 'getPreviewUrl';
    }
}
