# Neos node types.

This package provides common node types for Neos CMS.

## Added node types

### Grid
The grid node type provides a simple grid with distribution properties. This
node type acts as base and does not provide any grid items that can be placed
inside this grid, as they are project-specific.

To add a custom grid item: Set up your node type and add
`'Newland.NeosNodeTypes:GridMixIn': true` as super type to get distribution
options. They are placed inside the inspector group `grid` which is provided.


### Page reference
The page reference node type works similar to the content reference node type,
but works with pages instead.


### Toggle
The toggle node type provides a way to hide its child nodes and reveal them when clicking the Toggle's title.

A toggle is wrapped with a `o-container` element by default. This wrapping can be changed by overriding it within a project's fusion. 

Extending allowed child node types needs to happens in an individual project's configuration.

Requirements:

- `target-enhancment` JavaScript package
- Styling partial called `_toggle.scss`. A default will ship with the Stylguide Skeleton to allow Plug & Play when used in new projects.


### Link Mixin
Due to neos link editors lacking the ability to define a title field and a link
target (new window vs same window), a link mixin is available that provides a
link field, a title tag, and a checkbox to open said link in a new window.


## Removed node types
The following node types are defined as abstract in order to remove them from
the "insert new node type" dialog:

  * Insert Plugin View
  * Columns
  * Two columns
  * Three columns
  * Four columns
  * Text with image
