<?php
namespace Newland\NeosNodeTypes\Video;

use Newland\NeosNodeTypes\Service\VimeoPreviewService;
use Neos\Flow\Annotations as Flow;

class VimeoVideo extends AbstractVideo
{

    /** @var string */
    private $videoId;

    /**
     * @var VimeoPreviewService
     * @Flow\Inject()
     */
    protected $videoPreview;

    public function __construct(string $url)
    {
        $this->videoId = $this->extractVideoId($url);
    }

    public function getEmbedUrl(): string
    {
        return '//player.vimeo.com/video/' . $this->videoId . '?autoplay=1';
    }

    public function getPreviewUrl(): string
    {
        return (string) $this->videoPreview->getPreviewImage($this->videoId, VimeoPreviewService::SIZE_LARGE);
    }

    private function extractVideoId(string $url): string
    {
        $pathParts = explode('/', parse_url($url)['path']);
        return array_pop($pathParts);
    }
}
