<?php
namespace Newland\NeosNodeTypes\Eel\Helper;

use Neos\Eel\ProtectedContextAwareInterface;
use Newland\NeosNodeTypes\Exception\UnknownVideoException;
use Newland\NeosNodeTypes\Video\VimeoVideo;
use Newland\NeosNodeTypes\Video\YoutubeVideo;

class VideoHelper implements ProtectedContextAwareInterface
{

    public function urlToVideo($url)
    {
        if (!$url) {
            return null;
        }

        if (strpos($url, 'youtube') !== false) {
            return new YoutubeVideo($url);
        }

        if (strpos($url, 'vimeo') !== false) {
            return new VimeoVideo($url);
        }

        throw new UnknownVideoException('The video url ' . $url . ' cannot be resolved');
    }

    public function allowsCallOfMethod($methodName): bool
    {
        return true;
    }
}
