<?php
namespace Newland\NeosMetaTags\Extractor;

/*
 * This file is part of the "neos-meta-tags" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\NeosMetaTags\Domain\Model\MetaData;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Configuration\ConfigurationManager;
use Neos\Flow\Property\PropertyMapper;
use Neos\Flow\Annotations as Flow;
use Newland\NeosCommon\Service\RecordService;
use Newland\NeosMetaTags\Domain\Model\Scenario;

class RequestExtractor extends BaseExtractor
{
    /**
     * @var PropertyMapper
     * @Flow\Inject()
     */
    protected $propertyMapper;
    /**
     * @var RecordService
     * @Flow\Inject()
     */
    protected $recordService;

    public function extractAll(Node $node, Scenario $scenario): MetaData
    {
        $record = $this->propertyMapper->convert(
            $scenario->getRecordIdentifier(),
            $scenario->getObjectType()
        );

        $metaData = new MetaData();
        $title = $this->recordService->getProperty($record, $scenario->getPropertyMappingFor('title'));

        $description = strip_tags(
            $this->recordService->getProperty($record, $scenario->getPropertyMappingFor('description'))
        );
        $image = $this->recordService->getProperty($record, $scenario->getPropertyMappingFor('image'));

        $metaData->setTitle($this->appendWebsite($title, $node));
        $metaData->setDescription(strip_tags($description));
        $metaData->setUrl($scenario->getUrl());

        $metaData->setOgType($scenario->getOgType());
        $metaData->setOgTitle($title);
        $metaData->setOgDescription(strip_tags($description));
        $metaData->setOgThumbnail($this->thumbnailService->getThumbnailDataFromExternalImage($image));
        $metaData->setOgImageAltText($title);

        $metaData->setTwitterType(MetaData::TWITTER_CARD_TYPE_DEFAULT);
        $metaData->setTwitterTitle($title);
        $metaData->setTwitterDescription(strip_tags($description));
        $metaData->setTwitterImage($image);
        $metaData->setTwitterCreator($this->twitterHandle);

        return $metaData;
    }

    public function extractTitle(Node $node, Scenario $scenario, bool $appendWebsite = false): ?string
    {
        $record = $this->propertyMapper->convert(
            $scenario->getRecordIdentifier(),
            $scenario->getObjectType()
        );

        $recordTitle = $this->recordService->getProperty($record, $scenario->getPropertyMappingFor('title'));

        if ($appendWebsite) {
            $recordTitle = $this->appendWebsite($recordTitle, $node);
        }

        return $recordTitle;
    }

    public function extractDescription(Scenario $scenario): ?string
    {
        $record = $this->propertyMapper->convert(
            $scenario->getRecordIdentifier(),
            $scenario->getObjectType()
        );

        $description = $this->recordService->getProperty($record, $scenario->getPropertyMappingFor('description'));

        $metaData = new MetaData();
        $metaData->setDescription($description);

        return $metaData->getDescriptionTrimmed();
    }
}
