<?php
namespace Newland\NeosMetaTags\ViewHelpers;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Neos\Flow\Annotations as Flow;
use Newland\NeosMetaTags\Service\MetaDataService;

class NodeTitleViewHelper extends AbstractViewHelper
{
    /**
     * @var MetaDataService
     * @Flow\Inject()
     */
    protected $metaDataService;

    public function initializeArguments(): void
    {
        $this->registerArgument('node', Node::class, 'Node to get the title of', true);
    }

    public function render(): string
    {
        return (string) $this->metaDataService->getTitle($this->arguments['node'], $this->controllerContext->getRequest());
    }
}
