<?php
namespace Newland\NeosMetaTags\Service;

/*
 * This file is part of the "neos-meta-tags" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\NeosMetaTags\Domain\Model\MetaData;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Mvc\ActionRequest;
use Neos\Flow\Mvc\RequestInterface;
use Neos\Flow\Annotations as Flow;
use Newland\NeosMetaTags\Extractor\PageExtractor;
use Newland\NeosMetaTags\Extractor\RequestExtractor;
use Newland\NeosMetaTags\Parser\RequestParser;

class MetaDataService
{
    /**
     * @var array
     * @Flow\InjectConfiguration()
     */
    protected $configuration;
    /**
     * @var RequestParser
     * @Flow\Inject()
     */
    protected $requestParser;
    /**
     * @var PageExtractor
     * @Flow\Inject()
     */
    protected $pageExtractor;
    /**
     * @var RequestExtractor
     * @Flow\Inject()
     */
    protected $requestExtractor;

    /**
     * @param Node $node
     * @param ActionRequest|RequestInterface $request
     * @return MetaData
     */
    public function getMetaData(Node $node, RequestInterface $request): MetaData
    {
        if (($request instanceof ActionRequest) === false) {
            return new MetaData();
        }

        $activeScenario = $this->requestParser->getActiveScenario($request, $this->configuration['scenarios'] ?? []);
        if ($activeScenario !== null) {
            return $this->requestExtractor->extractAll($node, $activeScenario);
        }

        return $this->pageExtractor->extractAll($node, $request);
    }

    /**
     * @param Node $node
     * @param ActionRequest|RequestInterface $request
     * @param bool $appendWebsite
     * @return string|null
     */
    public function getTitle(Node $node, RequestInterface $request, bool $appendWebsite = false): ?string
    {
        if (($request instanceof ActionRequest) === false) {
            return '';
        }

        $activeScenario = $this->requestParser->getActiveScenario($request, $this->configuration['scenarios'] ?? []);
        if ($activeScenario !== null) {
            return $this->requestExtractor->extractTitle($node, $activeScenario, $appendWebsite);
        }

        return $this->pageExtractor->extractTitle($node, $appendWebsite);
    }

    /**
     * @param Node $node
     * @param ActionRequest|RequestInterface $request
     * @return string
     */
    public function getDescription(Node $node, RequestInterface $request): ?string
    {
        if (($request instanceof ActionRequest) === false) {
            return '';
        }

        $activeScenario = $this->requestParser->getActiveScenario($request, $this->configuration['scenarios'] ?? []);
        if ($activeScenario !== null) {
            return $this->requestExtractor->extractDescription($node, $activeScenario);
        }

        return $this->pageExtractor->extractDescription($node);
    }

    /**
     * @param ActionRequest|RequestInterface $request
     * @return bool
     */
    public function isDetailPage(RequestInterface $request): bool
    {
        if (($request instanceof ActionRequest) === false) {
            return false;
        }

        return $this->requestParser->isDetailRequest($request, $this->configuration['scenarios'] ?? []);
    }
}
