<?php
namespace Newland\NeosMetaTags\Domain\Model;

/*
 * This file is part of the "neos-meta-tags" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class MetaData
{
    public const OG_TYPE_DEFAULT = 'website';
    public const TWITTER_CARD_TYPE_DEFAULT = 'summary';

    /** @var ?string */
    protected $title;

    /** @var ?string */
    protected $description;

    /** @var ?string */
    protected $url;

    /** @var ?string */
    protected $canonicalUrl;

    /** @var ?string */
    protected $ogTitle;

    /** @var ?string */
    protected $ogDescription;

    /** @var ?string */
    protected $ogType;

    /** @var ?array */
    protected $ogThumbnail = [];

    /** @var ?string */
    protected $ogImageAltText;

    /** @var ?string */
    protected $twitterType;

    /** @var ?string */
    protected $twitterTitle;

    /** @var ?string */
    protected $twitterDescription;

    /** @var ?string */
    protected $twitterCreator;

    /** @var ?string */
    protected $twitterImage;

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): self
    {
        $this->title = $title;
        return $this;
    }

    public function getDescription(): ?string
    {
        return strip_tags((string) $this->description);
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;
        return $this;
    }

    public function getDescriptionTrimmed(): ?string
    {
        $description = $this->getDescription();

        if (empty($description)) {
            return null;
        }

        if (strlen($description) > 150) {
            $description = substr($description, 0, 147) . '...';
        }

        return $description;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function setUrl(string $url): self
    {
        $this->url = $url;
        return $this;
    }

    public function getOgTitle(): ?string
    {
        return $this->ogTitle;
    }

    public function setOgTitle(?string $ogTitle): self
    {
        $this->ogTitle = $ogTitle;
        return $this;
    }

    public function getOgDescription(): ?string
    {
        return $this->ogDescription;
    }

    public function setOgDescription(?string $ogDescription): self
    {
        $this->ogDescription = $ogDescription;
        return $this;
    }

    public function getOgType(): ?string
    {
        return $this->ogType;
    }

    public function setOgType(?string $ogType): self
    {
        $this->ogType = $ogType;
        return $this;
    }

    public function getOgThumbnail(): ?array
    {
        return $this->ogThumbnail;
    }

    public function setOgThumbnail(?array $ogThumbnail): self
    {
        $this->ogThumbnail = $ogThumbnail;
        return $this;
    }

    public function getOgImageAltText(): ?string
    {
        return $this->ogImageAltText;
    }

    public function setOgImageAltText(?string $ogImageAltText): self
    {
        $this->ogImageAltText = $ogImageAltText;
        return $this;
    }

    public function getTwitterType(): ?string
    {
        return $this->twitterType;
    }

    public function setTwitterType(?string $twitterType): self
    {
        $this->twitterType = $twitterType;
        return $this;
    }

    public function getTwitterTitle(): ?string
    {
        return $this->twitterTitle;
    }

    public function setTwitterTitle(?string $twitterTitle): self
    {
        $this->twitterTitle = $twitterTitle;
        return $this;
    }

    public function getTwitterDescription(): ?string
    {
        return $this->twitterDescription;
    }

    public function setTwitterDescription(?string $twitterDescription): self
    {
        $this->twitterDescription = $twitterDescription;
        return $this;
    }

    public function getTwitterCreator(): ?string
    {
        return $this->twitterCreator;
    }

    public function setTwitterCreator(?string $twitterCreator): self
    {
        $this->twitterCreator = $twitterCreator;
        return $this;
    }

    public function getTwitterImage(): ?string
    {
        return $this->twitterImage;
    }

    public function setTwitterImage(?string $twitterImage): self
    {
        $this->twitterImage = $twitterImage;
        return $this;
    }

    public function getCanonicalUrl(): ?string
    {
        return $this->canonicalUrl;
    }

    public function setCanonicalUrl(?string $canonicalUrl): self
    {
        $this->canonicalUrl = $canonicalUrl;
        return $this;
    }
}
