<?php declare(strict_types=1);

namespace Newland\NeosMetaTags\Tests\Fusion;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\CompilesFusion;
use Newland\NeosTestingHelpers\InteractsWithNodes;

class TitleTagTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;
    use InteractsWithNodes, CompilesFusion;

    /** @var Node */
    protected $node;
    protected $siteTitle = 'site title';

    public function setUp(): void
    {
        parent::setUp();
        $this->node = $this->initializeNode(
            '/sites/foo-bar',
            null,
            $this->initializeSite('foo-bar', $this->siteTitle),
            [ 'title' => 'node title' ]
        );
    }

    public function testGeneratesTitleTag(): void
    {
        $result = $this->compileFusion($this->node, 'Newland.NeosMetaTags:TitleTag');
        $this->assertContains('<title>', $result);
        $this->assertContains('</title>', $result);
    }

    public function testUsesPageTitleIfNotOverwritten(): void
    {
        $result = $this->compileFusion($this->node, 'Newland.NeosMetaTags:TitleTag');
        $this->assertContains($this->siteTitle, $result);
        $this->assertContains('node title', $result);
    }

    public function testOmitsPageTitleAndSeparator(): void
    {
        $this->node->setProperty('title', null);
        $result = $this->compileFusion($this->node, 'Newland.NeosMetaTags:TitleTag');
        $this->assertEquals('<title>' . $this->siteTitle . '</title>', $result);
    }

    /** @doesNotPerformAssertions */
    public function testDoesNotFailIfCurrentNodeHasNoTitleAssociated():  void
    {
        $this->node->setProperty('title', null);
        $this->persistNode($this->node);
        $this->compileFusion($this->node, 'Newland.NeosMetaTags:TitleTag');
    }
}
