# Meta tags rendering for Neos CMS.

This package provides functionality for rendering meta tags for static pages
as well as detail view of records with no physical page.

## Integration

### Setup
Make sure the following variables are defined in the `head` section of your _Page.fusion_:

```fusion
prototype(Neos.NodeTypes:Page) < prototype(Neos.Neos:Page) {
    head {
        titleTag = Newland.NeosMetaTags:TitleTag
        metaDescriptionTag = Newland.NeosMetaTags:MetaDescription
        openGraphMetaTags = Newland.NeosMetaTags:OpenGraphMetaTags
        twitterCard = Newland.NeosMetaTags:TwitterCard
        canonicalLink = Newland.NeosMetaTags:CanonicalLink
    }
}
```

It is then possible to define a fallback hierarchy for different meta tags. In the following example for the meta description, we first use the `metaDescription` and fall back to the `introText` page property, if the `metaDescription` is empty. Similar settings are possible for Twitter Cards and Open Graph:

```yaml
Newland:
  NeosMetaTags:
    fallback:
      description:
        - metaDescription
        - introText
      twitter:
        description:
          - twitterCardDescription
          - openGraphDescription
          - metaDescription
          - introText
      og:
        description:
          - openGraphDescription
          - metaDescription
          - introText

    override: true
    scenarios:
      poiDetail:
        package: Vendor.Package
        controller: RecordController
        action: show
        parameter: record
        objectType: Vendor\Package\Domain\Model\Record
        ogType: article
        canonicalUrlGenerator: 'Vendor\Package\Meta\CanonicalUrlGenerator'
        propertyMapping:
          # Use a simple 1:1 mapping
          title: name
          # Or use a mapping with top to bottom fallback
          description:
            - abstract
            - description
          image: media.0.sourceUri
```
