<?php
namespace Newland\NeosMetaTags\Domain\Model;

/*
 * This file is part of the "neos-meta-tags" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class Scenario
{
    protected $objectType = '';
    protected $recordIdentifier = '';
    protected $propertyMapping = [];
    protected $ogType;
    protected $url = '';
    protected $nodePath = '';
    protected $canonicalUrlGenerator = null;

    public function getObjectType(): string
    {
        return $this->objectType;
    }

    public function setObjectType(string $objectType): void
    {
        $this->objectType = $objectType;
    }

    public function getRecordIdentifier(): string
    {
        return $this->recordIdentifier;
    }

    public function setRecordIdentifier(string $recordIdentifier): void
    {
        $this->recordIdentifier = $recordIdentifier;
    }

    public function getPropertyMapping(): array
    {
        return $this->propertyMapping;
    }

    public function setPropertyMapping(array $propertyMapping): void
    {
        $this->propertyMapping = $propertyMapping;
    }

    public function getPropertyMappingFor(string $property = ''): string
    {
        return $this->propertyMapping[$property] ?? '';
    }

    public function getOgType(): string
    {
        return $this->ogType;
    }

    public function setOgType(string $ogType): void
    {
        $this->ogType = $ogType;
    }

    public function getUrl(): string
    {
        return $this->url;
    }

    public function setUrl(string $url): void
    {
        $this->url = $url;
    }

    public function getCanonicalUrlGenerator(): ?string
    {
        return $this->canonicalUrlGenerator;
    }

    public function setCanonicalUrlGenerator(?string $canonicalUrlGenerator): void
    {
        $this->canonicalUrlGenerator = $canonicalUrlGenerator;
    }

    public function getNodePath(): string
    {
        return $this->nodePath;
    }

    public function setNodePath(string $nodePath): void
    {
        $this->nodePath = $nodePath;
    }
}
