<?php
namespace Newland\NeosMetaTags\Domain\Model;

/*
 * This file is part of the "neos-meta-tags" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class MetaData
{
    public const OG_TYPE_DEFAULT = 'website';
    public const TWITTER_CARD_TYPE_DEFAULT = 'summary';

    protected $title;
    protected $description;
    protected $url;

    protected $ogTitle;
    protected $ogDescription;
    protected $ogType;
    protected $ogThumbnail = [];
    protected $ogImageAltText;

    protected $twitterType;
    protected $twitterTitle;
    protected $twitterDescription;
    protected $twitterCreator;
    protected $twitterImage;

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): void
    {
        $this->title = $title;
    }

    public function getDescription(): ?string
    {
        return strip_tags((string) $this->description);
    }

    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    public function getDescriptionTrimmed(): ?string
    {
        $description = $this->getDescription();

        if (empty($description)) {
            return null;
        }

        if (strlen($description) > 150) {
            $description = substr($description, 0, 147) . '...';
        }

        return $description;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function setUrl(string $url): void
    {
        $this->url = $url;
    }

    public function getOgTitle(): ?string
    {
        return $this->ogTitle;
    }

    public function setOgTitle(?string $ogTitle): void
    {
        $this->ogTitle = $ogTitle;
    }

    public function getOgDescription(): ?string
    {
        return $this->ogDescription;
    }

    public function setOgDescription(?string $ogDescription): void
    {
        $this->ogDescription = $ogDescription;
    }

    public function getOgType(): ?string
    {
        return $this->ogType;
    }

    public function setOgType(?string $ogType): void
    {
        $this->ogType = $ogType;
    }

    public function getOgThumbnail(): ?array
    {
        return $this->ogThumbnail;
    }

    public function setOgThumbnail(?array $ogThumbnail): void
    {
        $this->ogThumbnail = $ogThumbnail;
    }

    public function getOgImageAltText(): ?string
    {
        return $this->ogImageAltText;
    }

    public function setOgImageAltText(?string $ogImageAltText): void
    {
        $this->ogImageAltText = $ogImageAltText;
    }

    public function getTwitterType(): ?string
    {
        return $this->twitterType;
    }

    public function setTwitterType(?string $twitterType): void
    {
        $this->twitterType = $twitterType;
    }

    public function getTwitterTitle(): ?string
    {
        return $this->twitterTitle;
    }

    public function setTwitterTitle(?string $twitterTitle): void
    {
        $this->twitterTitle = $twitterTitle;
    }

    public function getTwitterDescription(): ?string
    {
        return $this->twitterDescription;
    }

    public function setTwitterDescription(?string $twitterDescription): void
    {
        $this->twitterDescription = $twitterDescription;
    }

    public function getTwitterCreator(): ?string
    {
        return $this->twitterCreator;
    }

    public function setTwitterCreator(?string $twitterCreator): void
    {
        $this->twitterCreator = $twitterCreator;
    }

    public function getTwitterImage(): ?string
    {
        return $this->twitterImage;
    }

    public function setTwitterImage(?string $twitterImage): void
    {
        $this->twitterImage = $twitterImage;
    }
}
