<?php declare(strict_types=1);

namespace Newland\NeosIcons;

class Icon
{
    /** @var \SimpleXMLElement */
    private $parsed;

    public static function fromString(string $content): Icon
    {
        return new static(new \SimpleXMLElement($content));
    }

    public function __construct(\SimpleXMLElement $parsed)
    {
        $this->parsed = $parsed;
    }

    public function getParsed(): \SimpleXMLElement
    {
        return $this->parsed;
    }

    public function fill(string $color): self
    {
        $this->parsed->addAttribute('fill', $color);
        return $this;
    }

    public function toString(): string
    {
        return (string) $this->parsed->asXML();
    }

    public function overlayIcon(Icon $icon, int $x = null, int $y = null, int $width = null, int $height = null): Icon
    {
        $id = 'overlay_' . md5((string) \random_int(PHP_INT_MIN, PHP_INT_MAX));

        // Prepare base: must declare xlink:... namespace
        $base = clone $this->parsed;
        $base->addAttribute('xmlns:xlink', 'http://www.w3.org/1999/xlink');

        // Transform overlay data into <symbol> tag with id
        $symbol = $this->cloneXmlElementIntoNewContext($icon->getParsed(), $base->addChild('symbol'));
        $symbol->addAttribute('id', $id);

        // Build <use> tag pointing to that new symbol
        $use = $base->addChild('use');
        $use->addAttribute('xlink:href', '#' . $id, 'http://www.w3.org/1999/xlink');
        if ($x !== null) {
            $use->addAttribute('x', (string) $x);
        }
        if ($y !== null) {
            $use->addAttribute('y', (string) $y);
        }
        if ($width !== null) {
            $use->addAttribute('width', (string) $width);
        }
        if ($height !== null) {
            $use->addAttribute('height', (string) $height);
        }

        return new static($base);
    }

    private function cloneXmlElementIntoNewContext(
        \SimpleXMLElement $child,
        \SimpleXMLElement $newChild
    ): \SimpleXMLElement {
        foreach ($child->attributes() as $name => $content) {
            $newChild->addAttribute($name, (string) $content);
        }
        foreach ($child->children() as $content) {
            $this->cloneXmlElementIntoNewContext($content, $newChild->addChild($content->getName()));
        }
        return $newChild;
    }
}
