<?php declare(strict_types=1);

namespace Newland\NeosIcons;

use function Safe\opendir;
use function Safe\file_get_contents;

class IconUtility
{
    protected const ICON_DIR = 'resource://Newland.NeosIcons/Private/Icons/';
    protected const ICON_PATH = self::ICON_DIR . '{name}.svg';

    public function listAllAvailableIcons(): array
    {
        $dir = opendir(static::ICON_DIR);
        $icons = [];

        // phpcs:ignore
        while ($icon = readdir($dir)) {
            if (!$icon) {
                break;
            }
            if (strpos($icon, '.') === 0) {
                continue;
            }
            $icons[] = str_replace('.svg', '', $icon);
        }

        return $icons;
    }

    public function getIcon(string $name): Icon
    {
        $uri = $this->iconPath($name);
        if (!file_exists($uri)) {
            return $this->errorIcon(sprintf('Icon %s not found', $name));
        }
        return Icon::fromString(file_get_contents($uri));
    }

    public function errorIcon(string $message): Icon
    {
        $contents = file_get_contents($this->iconPath('question'));
        $contents .= '<!-- ' . $message . '-->';

        return Icon::fromString($contents);
    }

    private function iconPath(string $name): string
    {
        return str_replace('{name}', $name, static::ICON_PATH);
    }
}
