<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Items;

use Doctrine\ORM\Query\Expr;
use Newland\NeosFiltering\Contract\DataSourcedFilterItem;
use Newland\NeosFiltering\Contract\Expression;
use Newland\NeosFiltering\Contract\FilterItem;
use Newland\NeosFiltering\Contract\FilterItemCommon;
use Newland\NeosFiltering\Contract\HasDataSource;
use Newland\NeosFiltering\Contract\HasQueryString;
use Newland\NeosFiltering\Contract\HasVisibleState;
use Newland\NeosFiltering\Contract\HasTitle;
use Newland\NeosFiltering\Contract\NeedsDatabaseColumn;
use Newland\NeosFiltering\Contract\QueryBoundFilterItem;
use Newland\NeosFiltering\Contract\StatusIndicatingFilterItem;
use Newland\NeosFiltering\Contract\StatusIndicator;
use Newland\NeosFiltering\Contract\TitledFilterItem;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Select box: Allows the user to select a single value from a drop-down.
 */
class SelectBox implements
    FilterItem,
    QueryBoundFilterItem,
    DataSourcedFilterItem,
    TitledFilterItem,
    StatusIndicatingFilterItem
{
    use FilterItemCommon,
        HasTitle,
        NeedsDatabaseColumn,
        HasDataSource,
        HasQueryString,
        HasVisibleState;

    public function setState($state): void
    {
        $state = $this->extractValidDataSourceOptionsBasedOnStateString((array) $state);
        $this->state = $state[0] ?? null;
    }

    public function queryExpression(Expr $expr): Expression
    {
        $this->throwIfNoDatabaseColumnDeclared();
        $this->throwIfNoQueryString();
        if (empty($this->state)) {
            return Expression::empty();
        }

        return Expression::where(
            $expr->eq($this->databaseColumn, $expr->literal($this->state['value']))
        );
    }

    public function render(RenderingContextInterface $renderingContext)
    {
        $view = $this->initializeView();
        $view->assign('options', $this->getDataFromDataSource());
        return $view->render('SelectBox');
    }


    /** @return StatusIndicator[] */
    public function getStatusIndicators(): array
    {
        if (empty($this->state)) {
            return [];
        }

        $indicator = new StatusIndicator();
        $indicator->setId($this->getId());
        $indicator->setTitle($this->state['label']);
        return [ $indicator ];
    }
}
