# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.15.0] - 2019-12-05
### Fixed
- Prevent page from scrolling to top when using _show more_ / _show less_ in filters

### Changed
- The previous ambiguity between completely removing a filter and hiding it in the frontend has been removed by disallowing setting a filter item to `NULL`. Instead, the property `hideInFrontend` can be used to hide the filter visually, retaining it's filter logic for backend filtering or `disableCompletely` if you want to disable the filter logic completely.

### Actions Required
- If you have 'disabled' a filter item (e.g. in Events or POI) by setting it to `NULL` (or `~` in YAML), then you should switch to one of `hideInFrontend` or `disableCompletely`. You most likely will want to use `hideInFrontend`. If you don't this will yield an error message in the frontend.

  Before:
  ```yaml
  Newland:
    Toubiz:
      Events:
        filter:
          categories: ~
  ```
  
  After:
  ```yaml
  Newland:
    Toubiz:
      Events:
        filter:
          categories:
            hideInFrontend: true
  ```

## [1.14.5] - 2019-11-20
### Fixed
- Fixed obstructed items (e.g. items with `hideInFrontend: true`) not being used when mapping query strings. This lead to them not being included when building detail links.
- Fixed Simple string mapping (fallback for when no data source available) being used when no match is found in data source. This fix is purely cosmetic: It lead to unnecessarily verbose URLs with arguments for filter items that could not use them (e.g. `/list?service[]=foo&canNotUseFoo[]=foo&somethingDifferent[]=foo`)

## [1.14.1] - 2019-09-19
### Fixed
- Fixed package not being installable due to incorrect version constraints

### Removed
- Removed old filter testing code

## [1.14.0] - 2019-09-17
### Changed
- Adjust existing `img` tags to use lazy loading.
- Filter items that have no visual output take up no space on mobile.

## [1.13.1] - 2019-08-13
### Fixed
- Fixed non-data sourced items not being able to receive query overrides.
- Checkbox lists now have a new `searchBoxDisplayLimit` configuration option to hide the search box for few items.
- Sections now use correct markup for mobile device support
- Range sliders no longer display 2 headings

## [1.13.0] - 2019-08-01
## Added
- Initial release. Literally everything was added.
