<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Items;

use Newland\NeosFiltering\Contract\HasVisibleState;
use Newland\NeosFiltering\Contract\HasTitle;
use Newland\NeosFiltering\Contract\TitledFilterItem;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Displays a filter section: In contrast to a group a section has defined markup
 * that is being rendered out.
 *
 * Depending on the context a section may mean different things but it is always the top most
 * categorization of a filtler (e.g. rendered as tabs or drop-down menus).
 */
class Section extends Group implements TitledFilterItem
{
    use HasTitle,
        HasVisibleState;

    public function render(RenderingContextInterface $renderingContext)
    {
        $renderedItems = $this->renderItems($renderingContext);
        if (empty($renderedItems)) {
            return null;
        }

        $view = $this->initializeView();
        $view->assign('renderedItems', $renderedItems);
        return $view->render('Section');
    }
}
