<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Contract;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\NeosFiltering\RangeSource\RangeSource;

/**
 * Marks a filter item as Ranged:
 * These filters use a range source to determine minimum and maximum values for their bounds.
 */
interface RangedFilterItem extends FilterItem
{
    public function setRangeSource(RangeSource $rangeSource): void;
}
