<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Tests\Fixture;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Query\Expr;
use Newland\NeosFiltering\Contract\Expression;
use Newland\NeosFiltering\Contract\FilterItem;
use Newland\NeosFiltering\Contract\QueryBoundFilterItem;
use Newland\NeosFiltering\Contract\RangedFilterItem;
use Newland\NeosFiltering\Items\Root;
use Newland\NeosFiltering\RangeSource\RangeSource;
use TYPO3Fluid\Fluid\Core\Parser\SyntaxTree\NodeInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class ItemMock implements FilterItem, QueryBoundFilterItem, RangedFilterItem
{

    /** @var string */
    public $queryString;

    /** @var \Closure */
    public $expressionGenerator;

    /** @var mixed */
    public $state;

    /** @var string */
    public $name;

    /** @var NodeInterface */
    public $node;

    /** @var string */
    public $renderingResultToReturn;

    /** @var RangeSource */
    public $rangeSource;

    /** @var array */
    public $configuration;

    /** @var string */
    public $id;

    /** @var Root */
    protected $root;

    public function __construct($renderingResultToReturn = '', $expressionGenerator = null, $queryString = '')
    {
        $this->renderingResultToReturn = $renderingResultToReturn;
        $this->expressionGenerator = $expressionGenerator;
        $this->queryString = $queryString;
    }

    public function setRangeSource(RangeSource $rangeSource): void
    {
        $this->rangeSource = $rangeSource;
    }

    public function setQueryString(string $queryString): void
    {
        $this->queryString = $queryString;
    }

    public function getQueryString(): ?string
    {
        return $this->queryString;
    }

    public function queryExpression(Expr $expr): Expression
    {
        $generator = $this->expressionGenerator;
        if ($generator === null) {
            return Expression::where($expr->eq('foo', 'bar'));
        }
        return $generator($expr);
    }

    public function setState($value): void
    {
        $this->state = $value;
    }

    public function getState()
    {
        return $this->state;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function setNode(NodeInterface $node)
    {
        $this->node = $node;
    }

    public function getNode()
    {
        return $this->node;
    }

    public function render(RenderingContextInterface $renderingContext)
    {
        return $this->renderingResultToReturn;
    }

    public function setConfiguration(array $configuration): void
    {
        $this->configuration = $configuration;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setRoot(Root $root): void
    {
        $this->root = $root;
    }

    public function getRoot(): Root
    {
        return $this->root;
    }

    public function getQueryForOverrides(array $overrides): array
    {
        return [];
    }
}
