<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Tests\Integration;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosFiltering\Factory\DefaultFilterFactory;
use Newland\NeosFiltering\Items\Root;
use Symfony\Component\Yaml\Yaml;

class ArticleMinimalTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    public function testCreatesMinimalArticleFilterFromYaml(): void
    {
        $filter = $this->filterFromYaml();
        $this->assertTrue(true);
        // TODO Actually check the filter contents. This only checks for no exceptions.
    }

    private function filterFromYaml(): Root
    {
        $parsed = Yaml::parse(file_get_contents('resource://Newland.NeosFiltering/Private/ExampleConfigurations/ArticleMinimal.yaml'));
        return $this->objectManager
            ->get(DefaultFilterFactory::class)
            ->createFilter($parsed);
    }
}
