<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Tests\Fixture;

use Doctrine\ORM\Query\Expr;
use Newland\NeosFiltering\Contract\Expression;
use Newland\NeosFiltering\Contract\FilterItem;
use Newland\NeosFiltering\Contract\QueryBoundFilterItem;
use Newland\NeosFiltering\Contract\RangedFilterItem;
use Newland\NeosFiltering\RangeSource\RangeSource;
use TYPO3Fluid\Fluid\Core\Parser\SyntaxTree\NodeInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class ItemMock implements FilterItem, QueryBoundFilterItem, RangedFilterItem
{

    /** @var string */
    public $queryString;

    /** @var \Closure */
    public $expressionGenerator;

    /** @var mixed */
    public $state;

    /** @var string */
    public $name;

    /** @var NodeInterface */
    public $node;

    /** @var string */
    public $renderingResultToReturn;

    /** @var RangeSource */
    public $rangeSource;

    /** @var string */
    public $id;

    public function __construct($renderingResultToReturn = '', $expressionGenerator = null)
    {
        $this->renderingResultToReturn = $renderingResultToReturn;
        $this->expressionGenerator = $expressionGenerator;
    }

    public function setRangeSource(RangeSource $rangeSource): void
    {
        $this->rangeSource = $rangeSource;
    }

    public function setQueryString(string $queryString): void
    {
        $this->queryString = $queryString;
    }

    public function getQueryString(): ?string
    {
        return $this->queryString;
    }

    public function queryExpression(Expr $expr): Expression
    {
        $generator = $this->expressionGenerator;
        if ($generator === null) {
            return Expression::where($expr->eq('foo', 'bar'));
        }
        return $generator($expr);
    }

    public function setState($value): void
    {
        $this->state = $value;
    }

    public function getState()
    {
        return $this->state;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function setNode(NodeInterface $node)
    {
        $this->node = $node;
    }

    public function getNode()
    {
        return $this->node;
    }

    public function render(RenderingContextInterface $renderingContext)
    {
        return $this->renderingResultToReturn;
    }

    public function getId(): string
    {
        return $this->id;
    }
}
