<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Items;

use Doctrine\ORM\Query\Expr;
use Newland\NeosFiltering\Contract\CompositeFilterItem;
use Newland\NeosFiltering\Contract\Expression;
use Newland\NeosFiltering\Contract\FilterItem;
use Newland\NeosFiltering\Contract\FilterItemCommon;
use Newland\NeosFiltering\Contract\HasCombinationSettings;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Group of filter items that are combined with AND or OR logic.
 * This item has no rendered output itself: It simply renders it's children
 * and combines their query parts.
 */
class Group implements FilterItem, CompositeFilterItem
{
    use FilterItemCommon, HasCombinationSettings;

    /** @var FilterItem[] */
    protected $items = [];

    public function __construct(array $items = [])
    {
        foreach ($items as $item) {
            $this->addItem($item);
        }
    }

    public function addItem(FilterItem $item): void
    {
        $this->items[] = $item;
    }

    public function getChildrenItems(): array
    {
        return $this->items;
    }

    public function queryExpression(Expr $expr): Expression
    {
        $expressions = array_map(function (FilterItem $item) use ($expr) {
            return $item->queryExpression($expr);
        }, $this->items);
        $result = new Expression();
        $result->where = $this->combineWithCurrentCombinationMethod($expr, Expression::extractWhere($expressions));
        $result->having = $this->combineWithCurrentCombinationMethod($expr, Expression::extractHaving($expressions));
        return $result;
    }

    public function render(RenderingContextInterface $renderingContext)
    {
        return $this->renderItems($renderingContext);
    }

    protected function renderItems(RenderingContextInterface $renderingContext): string
    {
        $rendered = array_map(
            function (FilterItem $item) use ($renderingContext) {
                return $item->render($renderingContext);
            },
            $this->items
        );

        return trim(implode('', $rendered));
    }
}
