<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Contract;

/**
 * Default implementation for the `TitledFilterItem` interface.
 * Note: This interface only provides a common implementation - you must explicitly implement
 *       the `TitledFilterItem` interface if you want to mark your filter item as having a title.
 *
 * @see TitledFilterItem
 */
trait HasTitle
{
    protected $title;

    public function setTitle(string $title): void
    {
        $this->title = $title;
        $this->viewAssignments['title'] = $title;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }
}
