<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Contract;

/**
 * Default implementation for the `QueryBoundFilterItem` interface.
 * Note: This interface only provides a common implementation - you must explicitly implement
 *       the `QueryBoundFilterItem` interface if you want to mark your filter item as having a query string.
 *
 * @see QueryBoundFilterItem
 */
trait HasQueryString
{
    /** @var string */
    protected $queryString;

    public function getQueryString(): ?string
    {
        return $this->queryString;
    }

    public function setQueryString(string $queryString): void
    {
        $this->viewAssignments['queryString'] = $queryString;
        $this->queryString = $queryString;
    }

    protected function throwIfNoQueryString(): void
    {
        if ($this->queryString === null) {
            throw new \Exception('Please specify a query string');
        }
    }
}
