<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Contract;

use Neos\Neos\Service\DataSource\DataSourceInterface;
use function Safe\preg_replace;

/**
 * Default implementation for the `DataSourcedFilterItem` interface.
 * Note: This interface only provides a common implementation - you must explicitly implement
 *       the `DataSourcedFilterItem` interface if you want to mark your filter item as data sourced.
 *
 * @see DataSourcedFilterItem
 */
trait HasDataSource
{

    /** @var DataSourceInterface */
    protected $dataSource;

    /** @var array */
    protected $dataSourceArguments = [];

    public function setDataSource(DataSourceInterface $dataSource): void
    {
        $this->dataSource = $dataSource;
    }

    public function getDataSource(): ?DataSourceInterface
    {
        return $this->dataSource;
    }

    public function setDataSourceArguments(array $arguments): void
    {
        $this->dataSourceArguments = $arguments;
    }

    public function getDataSourceArguments(): array
    {
        return $this->dataSourceArguments;
    }

    protected function getDataFromDataSource(): array
    {
        $data = $this->dataSource->getData(
            null,
            $this->dataSourceArguments ?? []
        );

        return array_map(
            function (array $item) {
                $item['id'] = sprintf('%s-%s', $this->getId(), $item['value']);
                return $item;
            },
            $data
        );
    }
}
