<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Contract;

use Neos\FluidAdaptor\View\StandaloneView;
use TYPO3Fluid\Fluid\Core\Parser\SyntaxTree\NodeInterface;

/**
 * Common behaviour that helps implement the `FilterItem` interface.
 */
trait FilterItemCommon
{
    /** @var string */
    protected $id;

    /** @var mixed */
    protected $state;

    /** @var NodeInterface */
    protected $node;

    /** @var string */
    protected $renderableName;

    /** @var array */
    protected $viewAssignments = [];

    public function getId(): string
    {
        if ($this->id === null) {
            $this->id = 'filter-' . md5((string) mt_rand(0, 99999));
        }
        return $this->id;
    }

    public function setId(string $id): void
    {
        $this->id = $id;
    }


    public function setState($state): void
    {
        $this->state = $state;
    }

    public function getState()
    {
        return $this->state;
    }

    /**
     * Sets the parsed RootNode which must be handled by this Renderable. In the
     * default implementation these nodes are evaluated by render() and extracted
     * by the NodeConverter
     *
     * @param NodeInterface $node
     * @return void
     */
    public function setNode(NodeInterface $node)
    {
        $this->node = $node;
    }

    /**
     * @return NodeInterface
     */
    public function getNode(): NodeInterface
    {
        return $this->node;
    }

    /**
     * Returns the name of this Renderable - name must also be passed in constructor.
     * Implementations must always return a non-empty string even if setName() is not
     * called to set the specific name.
     *
     * @return string
     */
    public function getName(): string
    {
        return $this->renderableName;
    }

    /**
     * Setter for the name of this Renderable.
     *
     * @param string $name
     * @return void
     */
    public function setName($name): void
    {
        $this->renderableName = $name;
    }

    protected function initializeView(): StandaloneView
    {
        $view = new StandaloneView();
        $view->setTemplateRootPaths([ 'resource://Newland.NeosFiltering/Private/Templates' ]);
        $view->setLayoutRootPaths([ 'resource://Newland.NeosFiltering/Private/Layouts' ]);
        $view->setPartialRootPaths([ 'resource://Newland.NeosFiltering/Private/Partials' ]);
        $view->assignMultiple($this->viewAssignments);

        $view->assignMultiple(
            [
                'id' => $this->getId(),
                'state' => $this->state,
                'node' => $this->node,
            ]
        );
        return $view;
    }
}
