<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Contract;

/**
 * Simple DTO that is being used to transport information about the returned
 * expression of a filter item.
 */
class Expression
{
    public $where;
    public $having;

    public static function extractHaving(array $expressions): array
    {
        $having = array_map(function (Expression $expression) {
            return $expression->having;
        }, $expressions);
        return array_filter($having);
    }

    public static function extractWhere(array $expressions): array
    {
        $having = array_map(function (Expression $expression) {
            return $expression->where;
        }, $expressions);
        return array_filter($having);
    }

    public static function where($where): Expression
    {
        $expression = new Expression();
        $expression->where = $where;
        return $expression;
    }

    public static function having($where): Expression
    {
        $expression = new Expression();
        $expression->having = $where;
        return $expression;
    }

    public static function empty(): Expression
    {
        return new Expression();
    }
}
