<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Contract;

/**
 * Interface that must be implemented by filter items if they have children and that in turn
 * display the full extent of the filter.
 */
interface CompositeFilterItem extends FilterItem
{
    public function addItem(FilterItem $item): void;

    /** @return FilterItem[] */
    public function getChildrenItems(): array;
}
