<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Items;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\NeosFiltering\Contract\StatusIndicator;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * A collection of hidden checkboxes.
 *
 * The state must be set to an array containing strings for all selected options.
 *
 * Additional to the usual data source attributes `label` and `value` a data source may also
 * specify `queryString`. If an option has a `queryString` that string will be used in the
 * query.
 *
 * @example
 * $field = new CheckboxCollection();
 * $field->setQueryString('tags');
 * $field->setTitle('Article Tags');
 * $field->setDatabaseColumn('entity.tag');
 * $field->setDataSource(new DirectDataSource([
 *      [ 'label' => 'Foo', value => 'foo' ],
 *      [ 'label' => 'Bar', 'value' => 'bar', 'queryString' => 'uebernachten' ],
 *      [ 'label' => 'Baz', 'value' => 'baz' ],
 * ]));
 * $field->setState([ 'foo', 'bar' ]);
 */
class CheckboxListHidden extends CheckboxList
{
    public function render(RenderingContextInterface $renderingContext)
    {
        $view = $this->initializeView();
        $view->assignMultiple(
            [
                'stateValues' => $this->getStateValues(),
            ]
        );
        return $view->render('CheckboxListHidden');
    }

    /** @return StatusIndicator[] */
    public function getStatusIndicators(): array
    {
        return [];
    }
}
