<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Controller;

use Neos\Flow\Mvc\Controller\ActionController;
use Newland\NeosFiltering\Factory\DefaultFilterFactory;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;
use Symfony\Component\Yaml\Yaml;
use Neos\Flow\Annotations as Flow;
use function Safe\file_get_contents;

class ArticleController extends ActionController
{

    /**
     * @var DefaultFilterFactory
     * @Flow\Inject()
     */
    protected $filterFactory;

    /**
     * @var ArticleRepository
     * @Flow\Inject()
     */
    protected $articleRepository;

    public function indexAction()
    {
        $filter = $this->filterFactory->createFilter(
            Yaml::parse(file_get_contents(
                'resource://Newland.NeosFiltering/Private/ExampleConfigurations/ArticleMinimal.yaml'
            ))
        );

        $filter
            ->fillStateFromRootRequestArguments($this->request)
            ->setAction(
                [
                    '@action' => 'index',
                    '@controller' => 'Article',
                    '@package' => 'Newland.NeosFiltering',
                ],
                $this->request
            );

        $query = $filter->applyToQuery($this->articleRepository->createQueryBuilder('entity'));
        $query->andWhere('entity.mainType = 2');

        $count = (clone $query)->select('COUNT(entity) as count')
            ->getQuery()
            ->execute([], \Doctrine\ORM\Query::HYDRATE_ARRAY)[0]['count'] ?? 0;
        $articles = $query
            ->setMaxResults(30)
            ->getQuery()
            ->execute();

        $this->view->assign('count', $count);
        $this->view->assign('articles', $articles);
        $this->view->assign('filter', $filter);
    }
}
