<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Tests\Fixture\Domain\Model;

use Doctrine\Common\Collections\Collection;
use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\UuidInterface;

/**
 * @Flow\Entity()
 * @ORM\Table("newland_neosfiltering_testing_entity")
 */
class ExampleEntity
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue(strategy="UUID")
     * @ORM\Column(type="guid", unique=TRUE)
     * @var UuidInterface
     */
    public $uuid;

    /**
     * @ORM\ManyToMany(targetEntity="Newland\NeosFiltering\Tests\Fixture\Domain\Model\ExampleCategory", inversedBy="entities",
     *     fetch="EAGER")
     * @var Collection<ExampleCategory>
     */
    public $categories;

    /**
     * @ORM\ManyToMany(targetEntity="Newland\NeosFiltering\Tests\Fixture\Domain\Model\ExampleAttribute", inversedBy="entities",
     *     fetch="EAGER")
     * @var Collection<ExampleCategory>
     */
    public $attributes;

    /**
     * @var string
     */
    public $name;

    /**
     * @var string
     */
    public $tag;

    /**
     * @var float
     */
    public $number;
}
