<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Service;

use Newland\Contracts\Neos\Filter\Expression;

class ExpressionService
{

    public function extractHaving(array $expressions): array
    {
        $having = array_map(function (Expression $expression) {
            return $expression->having;
        }, $expressions);
        return array_filter($having);
    }

    public function extractWhere(array $expressions): array
    {
        $having = array_map(function (Expression $expression) {
            return $expression->where;
        }, $expressions);
        return array_filter($having);
    }
}
