<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Factory\Override;

use Newland\Contracts\Neos\Filter\FilterItem;
use Newland\NeosFiltering\Factory\OverrideBehaviour;
use Newland\NeosFiltering\Items\ObstructionWrapper;

class Preselect implements OverrideBehaviour
{
    public function applyOverride(FilterItem $item, $override, array $configuration): FilterItem
    {
        $item->setState($override);
        if (\count((array) $item->getState()) === 1) {
            return new ObstructionWrapper($item);
        }
        return $item;
    }
}
