<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Traits;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Contracts\Neos\Filter\TitledFilterItem;

/**
 * Default implementation for the `TitledFilterItem` interface.
 * Note: This interface only provides a common implementation - you must explicitly implement
 *       the `TitledFilterItem` interface if you want to mark your filter item as having a title.
 *
 * @see TitledFilterItem
 */
trait HasTitle
{
    /** @var ?string */
    protected $title;

    public function setTitle(?string $title): void
    {
        $this->title = $title;
        $this->viewAssignments['title'] = $title;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }
}
