<?php declare(strict_types=1);

namespace Newland\NeosFiltering\RangeSource;

use Newland\Contracts\Neos\Filter\RangeSource;

/**
 * Range source that outputs the values you pass to it's constructor.
 */
class DirectRangeSource implements RangeSource
{

    /** @var float */
    private $min;

    /** @var float */
    private $max;

    public function setArguments(array $arguments): void
    {
        $this->min = (float) $arguments['min'];
        $this->max = (float) $arguments['max'];
    }

    public function min(): float
    {
        return $this->min;
    }

    public function max(): float
    {
        return $this->max;
    }
}
