<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Tests\Factory;


use Doctrine\Common\Collections\ArrayCollection;
use Newland\NeosFiltering\Tests\Fixture\Domain\Model\ExampleEntity;
use Newland\Toubiz\Sync\Neos\Tests\Factory\AbstractFactory;

class ExampleEntityFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $entity = new ExampleEntity();
        $entity->name = $properties['name'] ?? $this->faker->name;
        $entity->tag = $properties['tag'] ?? $this->faker->word;
        $entity->number = $properties['number'] ?? $this->faker->randomFloat();
        if (array_key_exists('categories', $properties)) {
            $entity->categories = new ArrayCollection($properties['categories']);
        }
        if (array_key_exists('attributes', $properties)) {
            $entity->attributes = new ArrayCollection($properties['attributes']);
        }
        return $entity;
    }
}
