<?php declare(strict_types=1);
namespace Newland\NeosFiltering;

use Neos\Flow\Package\FlowPackageInterface;
use Neos\Flow\Package\GenericPackage;
use Symfony\Component\Finder\Finder;

class Package extends GenericPackage implements FlowPackageInterface
{

    /**
     * Returns the full path to this package's Resources directory
     *
     * @return string Path to this package's Resources directory
     * @api
     */
    public function getResourcesPath()
    {
        return $this->packagePath . FlowPackageInterface::DIRECTORY_RESOURCES;
    }

    /**
     * Returns the full path to this package's Configuration directory
     *
     * @return string Path to this package's Configuration directory
     * @api
     */
    public function getConfigurationPath()
    {
        return $this->packagePath . FlowPackageInterface::DIRECTORY_CONFIGURATION;
    }

    /**
     * Returns a generator of filenames of class files provided by functional tests contained in this package
     *
     * @return \Generator
     * @internal
     */
    public function getFunctionalTestsClassFiles()
    {
        $finder = new Finder();
        $finder->files()
            ->name('*.php')
            ->in(__DIR__ . '/../Tests/Fixture');

        foreach ($finder as $file) {
            $path = $file->getRealPath();
            if ($path === false) {
                continue;
            }

            $relativePath = str_replace(\dirname(__DIR__), '', $path);
            $relativePath = trim($relativePath, '/');
            $namespace = 'Newland\\NeosFiltering\\' . str_replace('/', '\\', $relativePath);
            $namespace = str_replace('.php', '', $namespace);

            yield $namespace => $path;
        }
    }

    /**
     * Returns the full path to this package's functional tests directory
     *
     * @return string Path to this package's functional tests directory
     * @internal
     */
    public function getFunctionalTestsPath()
    {
        return $this->packagePath . FlowPackageInterface::DIRECTORY_TESTS_FUNCTIONAL;
    }
}
