<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Service;

class DataSourceHelper
{
    public static function extractValidDataSourceOptionsBasedOnStateStrings(
        array $dataFromDataSource,
        array $state
    ): array {
        $state = array_filter(
            $dataFromDataSource,
            function (array $row) use ($state) {
                $queryString = $row['queryString'] ?? null;
                if ($queryString && \in_array($queryString, $state, true)) {
                    return true;
                }
                return \in_array($row['value'], $state, true);
            }
        );

        return array_values($state);
    }
}
