<?php declare(strict_types=1);
namespace Newland\NeosFiltering\StatusIndicator;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\View\StandaloneView;
use TYPO3Fluid\Fluid\Core\Rendering\AbstractRenderable;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class StatusIndicatorCollection extends AbstractRenderable
{
    protected $indicators = [];

    public function __construct(array $indicators)
    {
        $this->indicators = $indicators;
    }

    public function render(RenderingContextInterface $renderingContext)
    {
        if (\count($this->indicators) === 0) {
            return null;
        }

        $view = new StandaloneView();
        $view->setTemplateRootPaths([ 'resource://Newland.NeosFiltering/Private/Templates' ]);
        $view->setLayoutRootPaths([ 'resource://Newland.NeosFiltering/Private/Layouts' ]);
        $view->setPartialRootPaths([ 'resource://Newland.NeosFiltering/Private/Partials' ]);
        $view->assign('indicators', $this->indicators);
        return $view->render('StatusIndicatorCollection');
    }
}
