<?php declare(strict_types=1);
namespace Newland\NeosFiltering\StatusIndicator;

/*
 * This file is part of the "neos-filtering" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\View\StandaloneView;
use TYPO3Fluid\Fluid\Core\Parser\SyntaxTree\NodeInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderableInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class StatusIndicator implements RenderableInterface
{
    /** @var string */
    protected $title;

    /** @var string */
    protected $id;

    /** @var array */
    protected $resetEvent = null;

    /** @var NodeInterface */
    protected $renderingNode;

    public static function fromOption(array $option): self
    {
        $indicator = new StatusIndicator();
        $indicator->setTitle($option['label']);
        $indicator->setId($option['id']);
        return $indicator;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): void
    {
        $this->id = $id;
    }

    /**
     * @param RenderingContextInterface $renderingContext
     * @return mixed
     */
    public function render(RenderingContextInterface $renderingContext)
    {
        $view = new StandaloneView();
        $view->setTemplateRootPaths([ 'resource://Newland.NeosFiltering/Private/Templates' ]);
        $view->setLayoutRootPaths([ 'resource://Newland.NeosFiltering/Private/Layouts' ]);
        $view->setPartialRootPaths([ 'resource://Newland.NeosFiltering/Private/Partials' ]);
        $view->assignMultiple(
            [
                'id' => $this->id,
                'title' => $this->title,
            ]
        );

        if ($this->resetEvent) {
            $view->assign('resetEvent', $this->resetEvent);
        }
        return $view->render('StatusIndicator');
    }

    public function getName()
    {
        return static::class;
    }

    public function setName($name)
    {
        // Intentionally does nothing.
    }

    public function getResetEvent()
    {
        return $this->resetEvent;
    }

    public function setResetEvent($targetSelector, $eventName)
    {
        $this->resetEvent = [
            'target' => $targetSelector,
            'event' => $eventName,
        ];
    }

    public function setNode(NodeInterface $node)
    {
        $this->renderingNode = $node;
    }

    public function getNode()
    {
        return $this->renderingNode;
    }
}
