<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Tests\Unit\RangeSource;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosFiltering\RangeSource\SimpleDatabaseRangeSource;
use Newland\NeosFiltering\Tests\Factory\ExampleEntityFactory;
use Newland\NeosFiltering\Tests\Fixture\Domain\Model\ExampleEntity;

class SimpleDatabaseRangeSourceTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var SimpleDatabaseRangeSource */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = new SimpleDatabaseRangeSource();
        $this->subject->setArguments([ 'class' => ExampleEntity::class, 'column' => 'number' ]);
    }

    public function testFetchesBoundsFromDatabase(): void
    {
        (new ExampleEntityFactory($this->objectManager))->create([ 'number' => 5 ]);
        (new ExampleEntityFactory($this->objectManager))->create([ 'number' => 10 ]);
        (new ExampleEntityFactory($this->objectManager))->create([ 'number' => 15 ]);

        $this->assertEquals(5, $this->subject->min());
        $this->assertEquals(15, $this->subject->max());
    }

    public function testReturnsSameValuesIfOnlyOneEntryExists(): void
    {
        (new ExampleEntityFactory($this->objectManager))->create([ 'number' => 5 ]);

        $this->assertEquals(5, $this->subject->min());
        $this->assertEquals(5, $this->subject->max());
    }

    public function testProvidesNullIfNoBoundsExist(): void
    {
        $this->assertNull($this->subject->min());
        $this->assertNull($this->subject->max());
    }

}
