<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Tests\Unit\Contract;

use Neos\Flow\Tests\FunctionalTestCase;
use Neos\FluidAdaptor\View\StandaloneView;
use Newland\NeosFiltering\Contract\StatusIndicator;
use TYPO3Fluid\Fluid\Core\Rendering\RenderableInterface;

class StatusIndicatorTest extends FunctionalTestCase
{

    public function testIncludesTitleInRenderedOutput(): void
    {
        $indicator = new StatusIndicator();
        $indicator->setTitle('Test title goes here');
        $this->assertContains('Test title goes here', $this->render($indicator));
    }

    public function testPointsToGivenId(): void
    {
        $indicator = new StatusIndicator();
        $indicator->setId('this-is-a-test');
        $this->assertContains('href="#this-is-a-test"', $this->render($indicator));
    }

    protected function render(RenderableInterface $renderable): ?string
    {
        $view = new StandaloneView();
        $view->assign('subject', $renderable);
        $view->setTemplateSource('<f:render renderable="{subject}" />');
        return $view->render();
    }
}
