<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Tests\Fixture\RangeSource;
use Newland\NeosFiltering\RangeSource\RangeSource;

class ExampleRangeSource implements RangeSource
{
    /** @var array */
    protected $arguments;

    public function setArguments(array $arguments): void
    {
        $this->arguments = $arguments;
    }

    public function min(): ?float
    {
        return $this->arguments['base'] - $this->arguments['delta'];
    }

    public function max(): ?float
    {
        return $this->arguments['base'] + $this->arguments['delta'];
    }
}
